-- name: [CS] Cream the Rabbit
-- description: This be Cream. She wittle bnuuy. She go hop hop.\n\n\\#ff7777\\This Pack requires Character Select\nto use as a Library!

--[[
    API Documentation for Character Select can be found below:
    https://github.com/Squishy6094/character-select-coop/wiki/API-Documentation

    Use this if you're curious on how anything here works >v<
]]

local TEXT_MOD_NAME = "Cream the Rabbit"

-- Stops mod from loading if Character Select isn't on
if not _G.charSelectExists then
    djui_popup_create("\\#ffffdc\\\n"..TEXT_MOD_NAME.."\nRequires the Character Select Mod\nto use as a Library!\n\nPlease turn on the Character Select Mod\nand Restart the Room!", 6)
    return 0
end

local E_MODEL_CREAM = smlua_model_util_get_id("cream_geo") -- Located in "actors"

local TEX_CREAM_LIFE_ICON = get_texture_info("cream-icon") -- Located in "textures"
local TEX_CREAM_STAR_ICON = get_texture_info("star-icon") -- Located in "textures"

-- All Located in "sound"
local VOICETABLE_CREAM = {
    [CHAR_SOUND_ATTACKED] = 'cream_attacked.ogg',
       [CHAR_SOUND_COUGHING1] = 'cream_cough1.ogg',
       [CHAR_SOUND_COUGHING2] = 'cream_cough2.ogg',
       [CHAR_SOUND_COUGHING3] = 'cream_cough3.ogg',
       [CHAR_SOUND_DOH] = 'cream_doh.ogg',
       [CHAR_SOUND_DROWNING] = 'cream_silent.ogg',
       [CHAR_SOUND_DYING] = 'cream_dying.ogg',
       [CHAR_SOUND_EEUH] = 'cream_eeuh.ogg',
       [CHAR_SOUND_GROUND_POUND_WAH] = 'cream_groundpound_wah.ogg',
       [CHAR_SOUND_HAHA] = 'cream_haha.ogg',
       [CHAR_SOUND_HAHA_2] = 'cream_haha.ogg',
       [CHAR_SOUND_HELLO] = 'cream_hello.ogg',
       [CHAR_SOUND_HERE_WE_GO] = 'cream_here_we_go.ogg',
       [CHAR_SOUND_HOOHOO] = 'cream_hoohoo.ogg',
       [CHAR_SOUND_HRMM] = 'cream_hrmm.ogg',
       [CHAR_SOUND_IMA_TIRED] = 'cream_imtired.ogg',
       [CHAR_SOUND_LETS_A_GO] = 'cream_lets_go.ogg',
       [CHAR_SOUND_MAMA_MIA] = 'cream_awww.ogg',
       [CHAR_SOUND_ON_FIRE] = 'cream_onfire.ogg',
       [CHAR_SOUND_OOOF] = 'cream_oof.ogg',
       [CHAR_SOUND_OOOF2] = 'cream_oof.ogg',
       [CHAR_SOUND_PANTING] = {'cream_panting1.ogg', 'cream_panting2.ogg', 'cream_panting3.ogg'},
       [CHAR_SOUND_PUNCH_HOO] = 'cream_punch_hoo.ogg',
       [CHAR_SOUND_PUNCH_WAH] = 'cream_punch_wah.ogg',
       [CHAR_SOUND_PUNCH_YAH] = 'cream_punch_yah.ogg',
       [CHAR_SOUND_SNORING1] = 'cream_snoring1.ogg',
       [CHAR_SOUND_SNORING2] = 'cream_snoring2.ogg',
       [CHAR_SOUND_SNORING3] = 'cream_snoring3.ogg',
       [CHAR_SOUND_SO_LONGA_BOWSER] = 'cream_buhbye.ogg',
       [CHAR_SOUND_TWIRL_BOUNCE] = 'cream_whee.ogg',
       [CHAR_SOUND_UH] = 'cream_uh.ogg',
       [CHAR_SOUND_UH2] = 'cream_uh2.ogg',
       [CHAR_SOUND_UH2_2] = 'cream_uh2.ogg',
       [CHAR_SOUND_WAAAOOOW] = 'cream_scream.ogg',
       [CHAR_SOUND_WAH2] = 'cream_wah2.ogg',
       [CHAR_SOUND_WHOA] = 'cream_whoa.ogg',
       [CHAR_SOUND_YAHOO] = 'cream_yahoo.ogg',
       [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = {'cream_yahoo.ogg', 'cream_waha.ogg', 'cream_yippie.ogg'},
       [CHAR_SOUND_YAH_WAH_HOO] = {'cream_punch_yah.ogg', 'cream_punch_wah.ogg', 'cream_punch_wah.ogg'},
       [CHAR_SOUND_YAWNING] = 'cream_yawning.ogg'
   }

   -- All Located in "actors"
local CAPTABLE_CREAM = {
    normal = smlua_model_util_get_id("cream_cap_geo"),
    wing = smlua_model_util_get_id("cream_wing_cap_geo"),
    metal = smlua_model_util_get_id("cream_metal_cap_geo"),
    metalWing = smlua_model_util_get_id("cream_wing_cap_geo"),
}

local E_MODEL_CREAM_STAR = smlua_model_util_get_id("cream_star_geo") -- Located in "actors"

local PALETTE_CREAM = {
    [PANTS]  = "FCC201",
    [SHIRT]  = "FF5A00",
    [GLOVES] = "FFFFFF",
    [SHOES]  = "604D35",
    [HAIR]   = "F7A493",
    [SKIN]   = "F8E0B8",
    [CAP]    = "FF8F00",
    [EMBLEM] = "77B9E2",
}

--
-- All Located in "textures"
local creamHealthMeter = {
    label = {
        left = get_texture_info("creamhp-back-left"),
        right = get_texture_info("creamhp-back-right"),
    },
    pie = {
        [1] = get_texture_info("creamhp-pie-1"),
        [2] = get_texture_info("creamhp-pie-2"),
        [3] = get_texture_info("creamhp-pie-3"),
        [4] = get_texture_info("creamhp-pie-4"),
        [5] = get_texture_info("creamhp-pie-5"),
        [6] = get_texture_info("creamhp-pie-6"),
        [7] = get_texture_info("creamhp-pie-7"),
        [8] = get_texture_info("creamhp-pie-8"),
    }
}


--[[
    Note: If there are some functionalities you don't care
    to add such as palettes, you can freely remove the function
    for it, the only function you require is character_add
]]

local CSloaded = false
local function on_character_select_load()
    CT_CREAM = _G.charSelect.character_add("Cream the Rabbit", {"She a bnuuy, She go hop!", "", "Straight from Super Cream 64,", "she's ready to go make some new friends!", "", "HUD Sprites made by SketchMeister","New voice clips by MagaicalPoptarts"}, "Gamebun", {r = 248, g = 224, b = 184}, E_MODEL_CREAM, CT_CREAM, TEX_CREAM_LIFE_ICON)
    _G.charSelect.character_add_caps(E_MODEL_CREAM, CAPTABLE_CREAM)
    _G.charSelect.character_add_voice(E_MODEL_CREAM, VOICETABLE_CREAM)
    _G.charSelect.character_add_celebration_star(E_MODEL_CREAM, E_MODEL_CREAM_STAR, TEX_CREAM_STAR_ICON)
    _G.charSelect.character_add_palette_preset(E_MODEL_CREAM, PALETTE_CREAM)
    _G.charSelect.character_add_health_meter(CT_CREAM, creamHealthMeter)

    CSloaded = true
end

local function on_character_sound(m, sound)
    if not CSloaded then return end
    if _G.charSelect.character_get_voice(m) == VOICETABLE_CREAM then return _G.charSelect.voice.sound(m, sound) end
end

local function on_character_snore(m)
    if not CSloaded then return end
    if _G.charSelect.character_get_voice(m) == VOICETABLE_CREAM then return _G.charSelect.voice.snore(m) end
end

hook_event(HOOK_ON_MODS_LOADED, on_character_select_load)
hook_event(HOOK_CHARACTER_SOUND, on_character_sound)
hook_event(HOOK_MARIO_UPDATE, on_character_snore)

